
markup.push({


// MARK: block

DehumBlock:
{
	"+": "BlockTemplate",
	geNodeClass: "AHRADehumNode",
    h4PresetsId: "DehumPresets",
	gxPopoverInfo: "DehumPopover",
	gxLibraryIcon: "library.effect.generic",
	gxLibraryDescription: "Remove hum from audio",
	gxTitle: "Dehum",
	axTitle: "De Hum",
	gxChildViews:
	{
		frequency: {
			"+": "SliderView.blockFace.trackUnfilled",
			gxValueKey: "node.baseFrequency",
			gxRangeMin: 20,
			gxRangeMax: 1000,
			gxDefaultValue: 50,
			gxKeystrokeStepSize: 1,
			axTitle: "Base Frequency",
			axFormatter: "HertzFormatter",
		},
		frequencyLabel: {
			"+": "LabelView.left.foreColorTheme1.size11",
			gxFrameRect: "18,31,83,25",
			gxDefaultValue: "Base",
		},
		frequencyReadout: {
			"+": "LabelView.right.blockReadout",
			gxFrameRect: "18,31,83,25",
			gxValueKey: "node.baseFrequency",
			gxFormatter: "HertzFormatter",
			gxClickValue: 50
		},
		amount: {
			"+": "SliderView.blockFace.trackUnfilled",
			gxFrameRect: "14,84,92,23",
			gxValueKey: "node.amount",
			gxRangeMin: 1,
			gxRangeMax: 10,
			gxDefaultValue: 3,
			gxKeystrokeStepSize: 1,
			axTitle: "De hum Amount",
			axFormatter: "NumberFormatter",
		},
		amountLabel: {
			"+": "LabelView.left.foreColorTheme1.size11",
			gxFrameRect: "18,66,83,25",
			gxDefaultValue: "Amount",
		},
		amountReadout: {
			"+": "LabelView.right.blockReadout",
            gxFormatter: "NumberFormatter",
			gxFrameRect: "18,66,83,25",
			gxValueKey: "node.amount",
		}
	}
},

    
// MARK: popover

DehumPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Dehum",
	axTitle: "De Hum",
	gxCanDrawSubviewsIntoLayer: true,
	gxWantsLayer: true,
	gxLayout: [ "H:|-12-[self(284)]-12-|",	// sets popover width
				"V:|-12-[self]-12-|",
				"V:|-41-[group]-8-[presetsGroup]"  // sets popover height
	],
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
		group: {
			"+": "GroupView",
			gxLayout:
			[
				"H:|-0-[self]-0-|",
				"H:|-12-[frequency]-12-|",
				"H:|-12-[amount]-12-|",
				"V:|-30-[frequency]-22-[amount]-12-[infoText(16)]-16-|",

				"V:[frequencyLabel]-(-1)-[frequency]&alignLeft",
				"V:[frequencyReadout]-(-1)-[frequency]&alignRight",

				"V:[amountLabel]-(-1)-[amount]&alignLeft",
				"V:[amountReadout]-(-1)-[amount]&alignRight",

				"H:|-12-[infoIcon(16)]-8-[infoText]-11-|",

				"V:[amount]-11-[infoIcon]",
			],
			gxChildViews: {
				frequency: {
					"+": "SliderView",
					gxValueKey: "node.baseFrequency",
					gxRangeMin: 20,
					gxRangeMax: 1000,
					gxDefaultValue: 50,
					gxKeystrokeStepSize: 1,
					axTitle: "Base Frequency",
					axFormatter: "HertzFormatter",
				},
				frequencyLabel: labelView("Base Frequency"),
				frequencyReadout: {
					"+": "ReadoutView",
					gxValueKey: "node.baseFrequency",
					gxFormatter: "HertzFormatter",
					gxClickValue: 50
				},
				amount: {
					"+": "SliderView",
					gxValueKey: "node.amount",
					gxRangeMin: 1,
					gxRangeMax: 10,
					gxDefaultValue: 3,
					gxKeystrokeStepSize: 1,
					axTitle: "De hum Amount",
					axFormatter: "NumberFormatter",
				},
				amountLabel: labelView("Dehum Amount"),
				amountReadout: {
					"+": "ReadoutView",
                    gxFormatter: "NumberFormatter",
					gxValueKey: "node.amount",
					gxClickValue: 3
				},
				infoIcon: { "+": "InfoIcon" },
				infoText: {
					"+": "DescriptionLabelView",
					gxDefaultValue: "Remove low frequency humming from audio."
				},
			}
		}
	}
},

DehumPresets:
{
    gxBuiltInPresets:
    [
		{   presetName: "50 Hz (EU)",
            presetValues: {"dehumBaseFrequency": 50, "dehumAmount": 3 },
        },
		{
            presetName: "60 Hz (USA)",
            presetValues: {"dehumBaseFrequency": 60, "dehumAmount": 3 },
        }
	]
},


})
